Vue.component('patientWeightTrack', {

    props: [
        'routes',
        'events',
        'parent',
    ],

    data: function() {
        return {
            records: [],
            loading: false,
            add: false,
            errors: {},
            success: false,
            display: 5,
            defaultWeightRecord: {
                id: null,
                metric: 1,
                heightCm: '',
                heightFt: '',
                heightIn: '',
                weightKg: '',
                weightSt: '',
                weightLb: '',
            },
            record: {},
            deleteIndex: -1,
            todayDate: null,
            showingAll: false,
            eventIndex: 0,
            reviewID: null,
        };
    },

    mounted: function() {
        this.init();
    },

    watch: {
        events(stack) {
            // Because there may be more than one event at a time, loop through new events
            for (let i = this.eventIndex; i < stack.length; i++) {
                let event = stack[i];
                if (event.name === 'initReview') {
                    this.reviewID = event.data.reviewId;
                    this.load();
                }
                if (event.name === 'weightTrackUpdated') {
                    this.load();
                }
            }
            // Update event index so that we don't process already processed events
            this.eventIndex = stack.length;
        }
    },

    computed: {
        canShowAll() {
            if (!this.records.length) {
                return false;
            }
            if (this.showingAll) {
                return false;
            }
            return this.records.length > this.display;
        }
    },

    methods: {
        init() {
            this.record = { ...this.defaultWeightRecord };
            // Don't load BP records if it's on the review page
            if (this.parent !== 'review') {
                this.load();
            }
        },
        load() {
            this.loading = true;

            let params = {};

            if (this.parent === 'review') {
                if (typeof this.reviewID !== 'undefined' && this.reviewID > 0) {
                    params = {
                        review_id: this.reviewID,
                    };
                }
            }

            let vm = this;

            this.$http.post(this.routes['admin-patient-weight-track-load'], params)
                .then((response) => {

                    const data = response.data;

                    vm.records = data.weightTrack;
                    vm.todayDate = data.todayDate;
                    vm.defaultWeightRecord.heightCm = data.height;
                    vm.defaultWeightRecord.heightFt = data.heightImperial[0];
                    vm.defaultWeightRecord.heightIn = data.heightImperial[1];
                    vm.loading = false;
                });
        },
        addRecord() {
            this.add = true;
            this.record = { ...this.defaultWeightRecord };
            $('#weightTrackDate' + this.parent).val(this.todayDate);
        },
        cancel() {
            this.add = false;
        },
        store() {
            if (this.loading) {
                return;
            }
            this.errors = {};
            this.success = false;
            this.loading = true;

            this.record.date_provided = $('#weightTrackDate' + this.parent).val();

            this.record.review_id = this.reviewID;

            let vm = this;

            this.$http.post(this.routes['admin-patient-weight-track-store'], this.record)
                .then((response) => {

                    const data = response.data;

                    if (data.errors) {
                        vm.errors = data.errors;
                        this.loading = false;
                        return;
                    }
                    if (data.success) {
                        vm.success = data.success;
                    }
                    vm.record = { ...vm.defaultWeightRecord };
                    vm.add = false;
                    vm.emitEvent('weightTrackUpdated');
                });
        },
        showConfirmDeletion(index) {
            this.deleteIndex = index;
        },
        deleteRecord(id) {
            if (this.loading) {
                return;
            }
            this.errors = {};
            this.success = false;
            this.loading = true;

            let vm = this;

            this.$http.post(this.routes['admin-patient-weight-track-delete'], {
                id: id,
            })
                .then((response) => {

                    const data = response.data;

                    if (data.errors) {
                        vm.errors = data.errors;
                        this.loading = false;
                        return;
                    }
                    if (data.success) {
                        vm.success = data.success;
                    }
                    vm.showConfirmDeletion(-1);
                    vm.emitEvent('weightTrackUpdated');
                });
        },
        showAll() {
            this.showingAll = true;
        },
        emitEvent(name, data) {
            this.$parent.emitEvent(name, data);
        },
    },
});
