<?php
/**
 * Class IdCheckLog
 *
 * @package Mtc\Plugins\LexisNexisIDU\Classes
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Plugins\LexisNexisIDU\Classes;

use Illuminate\Database\Eloquent\Model;
use Mtc\Modules\Members\Models\Member;
use Mtc\Shop\Order;

/**
 * Class IdCheckLog
 *
 * Logger for ID check functionality
 *
 * @package Mtc\Plugins\LexisNexisIDU\Classes
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class IdCheckLog extends Model
{
    /**
     * @var string $table table used by model
     */
    protected $table = 'log_id_checks';

    /**
     * @var string[] $fillable fields that are mass assignable
     */
    protected $fillable = [
        'order_id',
        'member_id',
        'passed',
        'request',
        'response',
        'raw_response',
        'endpoint',
    ];

    /**
     * Relationship with order
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    /**
     * Relationship with member
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function member()
    {
        return $this->belongsTo(Member::class);
    }

}
