<?php

$pluginName = 'NewsletterSignup';

/**
 * Newsletter Plugin
 *
 * This loader.php file is brought in as part of header.inc.php automatically, as long as the folder is within /plugins/
 * Do not output anything directly in this file as it is included within header.inc.php
 * Use hooks and twig templates to produce your content
 *
 * @author Paul McAvoy <paul.mcavoy@mtcmedia.co.uk>
 */

use Mtc\Plugins\NewsletterSignup\Classes\NewsletterServiceProvider;

if (!defined('NEWSLETTER_SIGNUP_INSTALLED')) {
    require_once __DIR__ . '/install/install.php';
}

if (NEWSLETTER_SIGNUP_INSTALLED === true ) {
    NewsletterServiceProvider::register();
}

// if POPUP is set to true add newsletter_popup_trigger.twig to footer using hooks
if (POPUP === true) {
    HooksAdapter::add_action(
        'footer',
        '\Mtc\Plugins\NewsletterSignup\Classes\Newsletter::addPopupTrigger',
        10, // Priority - 10 is default
        0, // Accepted args from hook
        [ $twig ] // forced args passed to hook
    );
}
