<?php

namespace Mtc\Plugins\Realex\Classes;

use Illuminate\Database\Eloquent\Model;


class RealexLog extends Model
{

    protected $table = 'realex_responses';

    protected $fillable = [
        'type',
        'order_id',
        'response',
    ];


    public static function saveResponse(String $response, int $order_id, $type = 'n/a')
    {
        self::create([
            'order_id' => $order_id,
            'type' => $type,
            'response' => $response,
        ]);
    }

}
