<?php
/**
 * Rich Card Schema Class
 *
 * This code is used to render the required schema for a page
 *
 * @author   mtc. Kieran McBurney <kieran.mcburney@mtcmedia.co.uk>
 */
namespace Mtc\Plugins\RichCardSchema\Classes;

use Twig\Environment;

class RichCardSchema
{
    
    /**
     * RichCardSchema::addContactPage()
     *
     * Render contact page rich card schema
     *
     * @access public
     * @static
     *
     * @param  Page             $p    CMS page object
     * @param  Environment $twig Twig render handler
     *
     * @return void
     */
    public static function addContactPage($p, Environment $twig)
    {
        if (empty($p)) {
            return;
        }
        echo $twig->render('schemas/contact_page_schema.twig', [
            'p' => $p
        ]);
    }
    
    /**
     * RichCardSchema::addItemSchema()
     *
     * Render item rich card schema
     *
     * @access public
     * @static
     *
     * @param  Item             $item item object
     * @param Environment $twig Twig render handler
     *
     * @return null
     */
    public static function addItemSchema(\Item $item, Environment $twig)
    {
        echo $twig->render('schemas/item_schema.twig', [
            'item' => $item
        ]);
    }
}
