<?php

use Mtc\Core\Models\CountryState;
use Mtc\Modules\Members\Models\Member;

?>
<table>
    <tr>
        <td valign="top">
            <b>Shipping Address</b><br/>
            <?php
            if (SHIPPING_ADDRESS) {
                if ($_REQUEST['edit'] == 1) {
                    ?>
                    <div class="row">
                        <select name="shipping_gender">
                            <option value="">Select gender</option>
                            <?php
                            foreach (Member::$genders as $gender) {
                                $selected = $order->address['shipping']['gender'] === $gender ? 'selected' : '';
                                echo '<option value="' . $gender . '" ' . $selected . '>' . $gender . '</option>';
                            }
                            ?>
                        </select>
                    </div>
                    <input type="text" name="shipping_firstname" placeholder="First Name" value="<?= clean_page($order->address['shipping']['firstname']);?>"/>
                    <input type="text" name="shipping_lastname" placeholder="Last Name" value="<?= clean_page($order->address['shipping']['lastname']);?>"/><br/>
                    <input type="text" name="shipping_address1" placeholder="Address Line 1" value="<?= clean_page($order->address['shipping']['address1']);?>"/><br/>
                    <input type="text" name="shipping_address2" placeholder="Address Line 2" value="<?= clean_page($order->address['shipping']['address2']);?>"/><br/>
                    <input type="text" name="shipping_city" placeholder="City" value="<?= clean_page($order->address['shipping']['city']);?>"/><br/>
                    <input type="text" name="shipping_country" placeholder="Country Code" value="<?= clean_page($order->address['shipping']['country']);?>"/><br/>
                    <input type="text" name="shipping_postcode" placeholder="Postcode" value="<?= clean_page($order->address['shipping']['postcode']);?>"/>
                <?php
                } else {
                    ?>
                    <?= clean_page($order->address['shipping']['firstname']);?> <?= clean_page($order->address['shipping']['lastname']);?> (<?= clean_page($order->address['shipping']['gender']);?>)<br/>
                    <?= clean_page($order->address['shipping']['address1']);?><br/>
                    <?php if($order->address['shipping']['address2'] != '') echo clean_page($order->address['shipping']['address2']) . '<br/>';?>
                    <?= clean_page($order->address['shipping']['city']);?><br/>
                    <?php
                        // Check if shipping state is not empty string, then get CountryState::getNameByCode($countryId, $stateId)
                        if($order->address['shipping']['state']) {
                            echo clean_page(CountryState::getNameByCode($order->address['shipping']['country'], $order->address['shipping']['state'])) . '<br/>';
                        }
                    ?>
                    <?= clean_page($countries[$order->address['shipping']['country']]);?><br/>
                    <?= clean_page($order->address['shipping']['postcode']);?><br/>
                <?php
                }
            } else {
                ?>
                <?= clean_page($order->address['billing']['firstname']);?> <?= clean_page($order->address['billing']['lastname']);?> (<?= clean_page($order->address['billing']['gender']);?>)<br/>
                <?= clean_page($order->address['billing']['address1']);?><br/>
                <?php
                    if ($order->address['billing']['address2'] != '') {
                        echo clean_page($order->address['billing']['address2']) . '<br/>';
                    }
                ?>
                <?= clean_page($order->address['billing']['city']);?><br/>
                <?php
                    // Check if billing state is not empty string, then get CountryState::getNameByCode($countryId, $stateId)
                    if ($order->address['billing']['state']) {
                        echo clean_page(CountryState::getNameByCode($order->address['billing']['country'], $order->address['billing']['state'])) . '<br/>';
                    }
                ?>
                <?= clean_page($countries[$order->address['billing']['country']]);?><br/>
                <?= clean_page($order->address['billing']['postcode']);?><br/>
            <?php
            }

            if ($_REQUEST['edit'] == 1) {
                ?>
                <input type="text" name="contact_no" value="<?= clean_page($order->info['contact_no']);?>"/><br/>
            <?php
            } else {
                ?>
                Phone: <?= $order->info['contact_no'];?>
            <?php
            }
            if (!empty($order->address['shipping']['notes'])) {
                ?>
                <p class="row">
                    <strong>Alternate shipping address notes</strong><br />
                    <?= clean_page($order->address['shipping']['notes']) ?>
                </p>
                <?php
            }
            if (ORDER_NOTES_ENABLED && !empty($order->info['message'])){ ?>
                <p class="row">
                    <strong>Order notes</strong><br />
                    <?= clean_page($order->info['message']); ?>
                </p>
            <?php } ?>
        </td>
        <td valign="top">
            <b>Billing Address</b><br/>
            <?php
            if ($_REQUEST['edit'] == 1) {
                ?>
                <div class="row">
                    <select name="billing_gender">
                        <option value="">Select gender</option>
                        <?php
                        foreach (Member::$genders as $gender) {
                            $selected = $order->address['billing']['gender'] === $gender ? 'selected' : '';
                            echo '<option value="' . $gender . '" ' . $selected . '>' . $gender . '</option>';
                        }
                        ?>
                    </select>
                </div>
                <input type="text" name="billing_firstname" placeholder="First Name" value="<?= clean_page($order->address['billing']['firstname']);?>"/>
                <input type="text" name="billing_lastname" placeholder="Last Name" value="<?= clean_page($order->address['billing']['lastname']);?>"/><br/>
                <input type="text" name="billing_address1" placeholder="Address Line 1" value="<?= clean_page($order->address['billing']['address1']);?>"/><br/>
                <input type="text" name="billing_address2" placeholder="Address Line 2" value="<?= clean_page($order->address['billing']['address2']);?>"/><br/>
                <input type="text" name="billing_city" placeholder="City" value="<?= clean_page($order->address['billing']['city']);?>"/><br/>
                <input type="text" name="billing_country" placeholder="Country Code" value="<?= clean_page($order->address['billing']['country']);?>"/><br/>
                <input type="text" name="billing_postcode" placeholder="Postcode" value="<?= clean_page($order->address['billing']['postcode']);?>"/>
            <?php
            } else {
                ?>
                 <?= clean_page($order->address['billing']['firstname']);?> <?= clean_page($order->address['billing']['lastname']);?> (<?= clean_page($order->address['billing']['gender']);?>)<br/>
                <?= clean_page($order->address['billing']['address1']);?><br/>
                <?php
                    if($order->address['billing']['address2'] != '') {
                        echo clean_page($order->address['billing']['address2']) . '<br/>';
                    }
                ?>
                <?= clean_page($order->address['billing']['city']);?><br/>
                <?php
                    // Check if billing state is not empty string, then get CountryState::getNameByCode($countryId, $stateId)
                    if($order->address['billing']['state']) {
                        echo clean_page(CountryState::getNameByCode($order->address['billing']['country'], $order->address['billing']['state'])) . '<br/>';
                    }
                ?>
                <?= clean_page($countries[$order->address['billing']['country']]);?><br/>
                <?= clean_page($order->address['billing']['postcode']);?><br/>
                Phone: <?= $order->info['contact_no'];?>
            <?php
            }
            ?>
        </td>
    </tr>
</table>
