<?php
/**
 * BelongsToBasket Trait.
 * @version 12/10/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */

namespace Mtc\Shop\Basket;

use Mtc\Shop\Basket;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * BelongsToBasket Trait.
 * Add ability to link any object to basket via basket_id column
 *
 * @version 12/10/16
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
trait BelongsToBasket
{
    /**
     * Scope - ofBasket()
     *
     * @param Builder $query Query to extend
     * @param Basket $item
     * @return Builder
     */
    public function scopeOfBasket(Builder $query, $basket)
    {
        return $query->where("basket_id", id($basket));
    }

    /**
     * Define Eloquent relationship to Basket class
     * @return BelongsTo
     */
    public function basket()
    {
        return $this->belongsTo(Basket::class, 'basket_id', 'id');
    }
}