<?php

namespace Mtc\Shop\Events;

/**
 * Class OrderPaidEvent
 *
 * This is an event class. Used to fire and handle an "Order Paid".
 * An instance of this class is passed to event handlers that subscribe to this event.
 *
 * @author Aleksey Lavrinenko
 * @version 2015-08-11
 */
class OrderPaidEvent
{
    /**
     * @var \Order
     */
    protected $order;

    protected $payment_type;

    /**
     * @return \Order
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @return string
     */
    public function getPaymentType()
    {
        return $this->payment_type;
    }

    /**
     * @param \Order $order Order that has peen paid
     * @param $payment_type
     */
    public function __construct(\Order $order, $payment_type)
    {
        $this->order = $order;
        $this->payment_type = $payment_type;
    }
}