<?php
/**
 * Model for Items Sizse Custom
 *
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 */
namespace Mtc\Shop\Item;

use \Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

/**
 * Model for Items Sizse Custom
 *
 * @author Uldis Zvirbulis <uldis.zvirbulis@mtcmedia.co.uk>
 */
class SizeCustom extends Model
{
    /**
     * @var array $guarded
     */
    protected $guarded = [
        'id'
    ];

    /**
     * @var bool $timestamps
     */
    public $timestamps = false;

    /**
     * @var string $table
     */
    protected $table = 'items_sizes_custom';

    /**
     * Returns variations' list of custom fields for the default custom field set.
     *
     * @return mixed
     */
    public static function getCustomFields()
    {
        return DB::table('custom_fields')
            ->select('custom_fields.*')
            ->join('custom_fields_sets_fields', 'custom_fields_sets_fields.custom_field_id', '=', 'custom_fields.id')
            ->join('custom_fields_sets', 'custom_fields_sets.id', '=', 'custom_fields_sets_fields.set_id')
            ->where('custom_fields_sets_fields.variations', '1')
            ->where('custom_fields_sets.default', '1')
            ->groupBy('custom_fields.id')
            ->orderBy('custom_fields.sort')
            ->get();
    }
}