<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Mtc\Modules\Members\Classes\Auth;

class AccountVerified
{
    /**
     * Directs user based on the roles, client access and client status
     *
     * @param Request $request
     * @param Closure $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        // If member not logged in, ignore
        if (!$member = Auth::getLoggedInMember()) {
            return $next($request);
        }
        // Allow access to MTC admin users
        if (!empty($_SESSION['adminId'])) {
            return $next($request);
        }
        return !empty($member->account_verified) ?
            $next($request) :
            redirect(route('members-verify', [], false));
    }
}
