<?php

use Mtc\Cms\Models\Page as CmsPage;

$cms_root_path = "../../../";
require_once($cms_root_path."includes/compatibility_includer.php");

$p = new Page();
if ( isset($_GET['page_id']) && is_numeric($_GET['page_id']) ) {
	$p->Get($_GET['page_id']);
} else {
	die("Page not found.");
}

$listing_page_logic = json_decode($p->logic, true);

$default_admin_listing_order = array("`order`");
if ( isset($listing_page_logic['default_admin_listing_order']) && !empty($listing_page_logic['default_admin_listing_order']) ) {
    $decoded = json_decode($listing_page_logic['default_admin_listing_order']);
    if ( $decoded !== false ) {
        $default_admin_listing_order = $decoded;
    }
}

$default_frontend_listing_order = array("`order`");
if ( isset($listing_page_logic['default_frontend_listing_order']) && !empty($listing_page_logic['default_frontend_listing_order']) ) {
    $decoded = json_decode($listing_page_logic['default_frontend_listing_order']);
    if ( $decoded !== false ) {
        $default_frontend_listing_order = $decoded;
    }
}

$date_value = array();
if ( isset($listing_page_logic['date_value']) && !empty($listing_page_logic['date_value']) ) {
    $decoded = json_decode($listing_page_logic['date_value']);
    if ( $decoded !== false ) {
        $date_value = $decoded;
    }
}

$columns = array("`title`","`updated`");
if ( isset($listing_page_logic['columns']) && !empty($listing_page_logic['columns']) ) {
    $decoded = json_decode($listing_page_logic['columns']);
    if ( $decoded !== false ) {
        $columns = $decoded;
    }
}

$adv_filters = array();
if ( isset($listing_page_logic['filter']) && !empty($listing_page_logic['filter']) ) {
    $decoded = json_decode($listing_page_logic['filter']);
    if ( $decoded !== false ) {
        $adv_filters = $decoded;
    }
}

$limits = array(20,50,0);
if ( isset($listing_page_logic['limits']) && !empty($listing_page_logic['limits']) ) {
    $decoded = json_decode($listing_page_logic['limits']);
    if ( $decoded !== false ) {
        $limits = $decoded;
    }
}

$ordering_enabled = 1;
if ( isset($listing_page_logic['ordering_enabled']) ) {
    $ordering_enabled = $listing_page_logic['ordering_enabled'];
}

$sorting_enabled = 1;
if ( isset($listing_page_logic['sorting_enabled']) ) {
    $sorting_enabled = $listing_page_logic['sorting_enabled'];
}


$quick_search_enabled = 1;
if ( isset($listing_page_logic['quick_search_enabled']) ) {
    $quick_search_enabled = $listing_page_logic['quick_search_enabled'];
}

$date_filter_enabled = 0;
if ( isset($listing_page_logic['date_filter_enabled']) ) {
    $date_filter_enabled = $listing_page_logic['date_filter_enabled'];
}

$listing_admin_info = "";
if ( isset($listing_page_logic['listing_admin_info']) ) {
    $listing_admin_info = $listing_page_logic['listing_admin_info'];
}





// LISTING PAGE
$listing_page = 1;
if ( !empty($_GET['listing_page']) ) {
    $listing_page = $_GET['listing_page'];
}

?>

<div class="pageActionBtns pageListingContainerActionBtns clearfix">
	<form><div class="row">
    <input type="hidden" name="data[page][id]" id="data[page][id]" value="" />
    <input type="hidden" name="listing_page" id="listing_page" value="<?=$listing_page?>" class="listingPage" />

    <?php
    if ( $_SESSION['content_manager']['is_mtcadmin'] || !empty($listing_admin_info) ) {
    ?>
    <fieldset class="topBarButtonFieldset pageFieldset">
        <?php
        if (  $_SESSION['content_manager']['is_mtcadmin'] ) {
            ?>
            <a href="manage_listing_settings.php?page_id=<?=$p->id?>" class="page-listing-container-settings-btn" title="Page Listing Container Settings">
                <i class="fa fa-cog"></i>
            </a>
            <a href="#" class="copyAllListedPages" title="Copy currently listed pages">
                <i class="fa fa-copy"></i>
            </a>
            <a href="#" class="pastePagesIntoListing" title="Paste Pages Into Listing">
                <i class="fa fa-paste"></i>
            </a>
            <a href="#" class="deleteAllListedPages" title="Delete all currently listed pages">
                <i class="fa fa-trash"></i>
            </a>
            <a href="#" class="changeListedPagesSubId" title="Change Listed Pages Sub ID">
                <i class="fa fa-share-square"></i>
            </a>
            <?php
        }
        if ( !empty($listing_admin_info) ) {
            ?>
            <a href="info.php?page_id=<?=$p->id?>" class="page-listing-container-info-btn" title="Listing Info">
                <i class="fa fa-info-circle"></i>
            </a>
            <?php
        }
        ?>
    </fieldset>
    <?php
    }


    if ( $_SESSION['content_manager']['is_mtcadmin'] ) {

        $sub_buttons = Page::getButtonList($p->id);

        echo "<div class='listing-buttons'>";

        foreach ($sub_buttons as $key => $sub_buton) {
            echo '<a class="cms-buttom-page" href="?page='.$sub_buton->id.'" title="'.$sub_buton->title.'"><button class="btn" type="button"><i class="fa fa-plus-circle btn-fa-icon"></i>'.$sub_buton->title.'</button></a>';
        }

    }

    if ( $quick_search_enabled == 1 ) {
        ?>
        <input type="search" class="INPUT1 listingQuickSearch" value="" name="search" style="width:20%; float:left" placeholder="quick search by title">
        <?php
    }

    ?>

    <button class="btn moveSelectedBtn">
        MOVE SELECTED PAGES
    </button>

    <?php $containers = CmsPage::find($p->id)->getTreeOfContainers() ?>

    <div class="moveSelectedDropdownWrap" style="display: none">
        <select class="moveSelectedDropdown" style="width: auto; margin-right: 4px;">
            <?php foreach ($containers as $container_key => $container): ?>
                <option value="<?= $container_key ?>">
                    <?= $container ?>
                </option>
            <?php endforeach ?>
        </select>
        <button class="btn moveSelectedAction" data-current-page-id="<?= $p->id ?>">
            MOVE
        </button>
    </div>


    <?php

    if ( !empty($date_filter_enabled) ) {
        $lister = Listing::newInstance($p->id)->run();
        $options = array(
            'index' => $date_value,
            'num_of_articles_string_format' => " (%d)",
            'month_format' => 'F Y'
        );
        $lister->getArchive($options);

        ?>
        <select name="limit" class="listingDateArchive" style="width:5%;" >
            <option value="">Filter by date</option>
            <?php
            foreach ($lister->archive as $year) {
                echo '<optgroup label="'.$year['title'].'">';
                    foreach ($year['sub'] as $month) {
                        $parsed_link = parse_url($month['link']);
                        parse_str($parsed_link['query'], $params);
                        echo '<option data-filter-from="'.$params['filter_from'].'" data-filter-to="'.$params['filter_to'].'" value="'.$month['link'].'">'.$month['title'].'</option>';
                    }
                echo '</optgroup>';
            }
            ?>
        </select>
        <?php
    }

    if (!empty($adv_filters)) {
        foreach ($adv_filters as $adv_filter) {
            if (is_array($adv_filter)) {
                // get a page with this pagedata
                $lister = Listing::newInstance($p->id)
                    ->setFilter([
                        [$adv_filter[0], null, "IS NOT"]
                    ])
                    ->setLimit(1)
                    ->run();
                $lister->getListing();

                foreach ($lister->list[0]->page_lists as $list) {
                    foreach ($list['items'] as $item) {
                        foreach ($item['data'] as $data) {
                            if ($data['name'] === $adv_filter[0]) {
                                if ( $data['type'] === "checkbox" ) {
                                    ?>
                                    <input class="listingAdvFilterInputType" type="hidden" name="<?=clean_page($data['name'])?>" value="checkbox">
                                    <label class="listingAdvFilterInputLabel">
                                        <?=clean_page($data['name'])?>
                                        <input
                                            type="checkbox"
                                            class="<?=clean_page($data['css_class'])?> listingAdvFilterInput listingAdvFilterInputOnChange"
                                            name="<?=clean_page($data['name'])?>"
                                        />
                                    </label>
                                    <?php
                                } elseif ( $data['type'] === "select" ) {
                                    ?>
                                    <input class="listingAdvFilterInputType" type="hidden" name="<?=clean_page($data['name'])?>" value="select">
                                    <select
                                        class="<?= clean_page($data['css_class']) ?> listingAdvFilterInput listingAdvFilterInputOnChange"
                                        name="<?=clean_page($data['name'])?>"
                                    >
                                        <option value="">- Select <?=clean_page($data['name'])?> -</option>
                                        <?php

                                        $select_options = array();
                                        if (!empty($data['options'])) {
                                            $select_options = ContentManagerPanel::getPagedataSelectOptions($data['options']);
                                        }

                                        foreach ($select_options as $option_value => $option_label) {
                                            ?>
                                            <option value="<?=clean_page($option_value)?>">
                                                <?=clean_page($option_label)?>
                                            </option>
                                            <?php
                                        }

                                        ?>
                                    </select>
                                    <?php
                                } else {
                                    ?>
                                    <input class="listingAdvFilterInputType" type="hidden" name="<?=clean_page($data['name'])?>" value="text">
                                    <input
                                        type="text"
                                        class="<?=clean_page($data['css_class'])?> listingAdvFilterInput listingAdvFilterInputOnInput"
                                        name="<?=clean_page($data['name'])?>"
                                        placeholder="by <?=clean_page($data['name'])?>"
                                    />
                                    <?php
                                }
                                break;
                            }
                        }
                    }
                }
            }
        }
    }
    ?>

	<select name="limit" class="listingLimit" style="width:5%; float:right; margin-left:0.5%" >
        <?php

        foreach ($limits as $key => $limit) {
            echo '<option value="'.$limit.'">Display '.($limit == 0 ? "all" : $limit).'</option>';
        }
        ?>
	</select>

    </div></form>
</div>

<div class="listingContainer clearfix" id="listingContainer"></div>
