<?php

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

//initialize variables
if (!isset($_REQUEST['action'])) {
    $_REQUEST['action'] = null;
}
$errors = null;

$page_meta['title'] = 'Manage SEO';

$seo_settings = new SeoSettings();

if ($_REQUEST['action'] == 'update') {
    if (isset($_REQUEST['settings']) && is_array($_REQUEST['settings'])) {
        foreach ($_REQUEST['settings'] as $key => $value) {
            $seo_settings->updateSettingValue($key, $value);
        }
    }
}

$seo_settings->getSettings();

require_once $path . 'core/admin/templates/adminheader.html.php';
?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li class="end"><?= clean_page($page_meta['title']) ?></li>
</ul>

<h1>Manage SEO</h1>
<?php
include('tabnav.php');
?>
<form action="<?= $_SERVER['PHP_SELF'] ?>" method="post">
    <fieldset>
        <h2>SEO Settings Manager</h2>
        <table class="manage-items">
            <tr>
                <th>Setting</th>
                <th>Value</th>
                <th>Description</th>
            </tr>
            <tbody class="tabular ui-sortable">
                <?php
                foreach ($seo_settings->settings as $setting) {
                    ?>
                    <tr>
                        <td><?= clean_page($setting['key']) ?></td>
                        <td>
                            <input type="text"
                                   name="settings[<?= clean_page($setting['key']) ?>]"
                                   value="<?= clean_page($setting['value']) ?>"
                                   style="width: 90%" />
                        </td>
                        <td><?= clean_page($setting['description']) ?></td>
                    </tr>
                    <?php
                }
                ?>
            </tbody>
        </table>
        <input type="hidden" name="action" value="update">
        <div class="search-button">
            <input type="submit" value="Update" class="BUTTON"/>
        </div>
    </fieldset>
</form>

<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';
