<?php

namespace Mtc\Modules\DoctorSurgery\Classes;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

init_request_values([
    'success' => null,
]);

$page_meta['title'] = 'Upload doctor list';

if(isset($_REQUEST['action']) && $_REQUEST['action'] === 'update') {

    $response = DoctorSurgery::importSurgeries();
    $errors = $response['errors'];
    if (empty($errors)) {
        $query_params = $_GET;
        $query_params['success'] = 'import_successful';
        header('location: /modules/DoctorSurgery/admin/upload.php?' . http_build_query($query_params));
        exit;
    }

}

require_once $path . 'core/admin/templates/adminheader.html.php';
?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li class="end">Upload doctor list</li>
</ul>

<h1>Upload doctor list</h1>

<?php

require __DIR__ . '/tabnav.php';

if ($_REQUEST['success'] === 'import_successful') {
    echo showmsg('Import Successful!', 'success', $path);
}

?>

<form action="upload.php" method="POST" class="style" enctype="multipart/form-data">
    <fieldset class="show">
        <h1><a class="show el">File upload <i class="fa fa-caret-right"></i></a></h1>
        <div class="row">
            <label for="file">File</label>
            <input type="file" name="import" id="file" />
        </div>
        <div class="row">
            CSV has to contain the following column names: <strong>ODS,Practice Name,Address Line 1,Address Line 2,Address Line 3,City,Postcode,Telephone Number</strong>
        </div>
    </fieldset>

    <input type="hidden" name="action" value="update" />
    <input type="submit" value="Upload" />
</form>
<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';
