<?php
/**
 * Form Answer Class.
 *
 * This code is used to process Form Answers to Form Questions
 *
 * @category Forms
 *
 * @author mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Modules\FormBuilder\Classes;

use Illuminate\Database\Eloquent\Model;

/**
 * Form Answer Class. Defines Form Answer model. Basic Eloquent model.
 * Stores Answer to a Question for a Form Response.
 * Single form response generates multiple answers.
 *
 * @category Forms
 *
 * @author mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class FormAnswer extends Model
{
    /**
     * @var string Classes associated table
     */
    protected $table = 'forms_responses_answers';

    /**
     * @var bool Disables use of eloquent timestamps
     */
    public $timestamps = false;

    /**
     * Form::question().
     *
     * define relationship with Question
     *
     * @access public
     * @return FormQuestion List of Response question answers
     */
    public function question()
    {
        return $this->belongsTo(FormQuestion::class, 'question_id');
    }

}
