<?php
namespace Mtc\Modules\FormBuilder\Classes;
/**
 * Ordering template for both questions & fieldsets
 *
 * @category Forms
 * @package  Mtc_Form_Builder
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
?>
<div class="orderingWrap clearfix">
    <div class="column"
        v-sortable-fieldset
    >
        <div class="portlet portletDisabled"
            v-bind:class="{ 'emptyPortlet' : unassigned_questions.length == 0 }"
            data-id="0"
        >
            <div class="portletHeader">Unassigned - Not shown on site</div>
            <div class="portletContent sortableQuestions"
                 v-sortable-question
                 data-fieldset="0">

                <div class="portletElement"
                     v-for="orderQuestion in unassigned_questions"
                     v-bind:id="'question_0-' + orderQuestion.id"
                     :data-id="orderQuestion.id">
                    <i class="fa fa-arrows"></i>
                    [% orderQuestion.name %]
                </div>
            </div>
        </div>
        <div class="portlet"
             v-for="fieldset in form.fieldsets"
             v-bind:class="{ 'emptyPortlet' : fieldsetIsEmpty(fieldset) }"
             :data-id="fieldset.id">
            <div class="portletHeader">
                [% fieldset.name %]
            </div>
            <div class="portletContent sortableQuestions"
                 v-sortable-question
                 :data-fieldset="fieldset.id">
                <div v-for="orderQuestion in fieldset.questions"
                     class="portletElement"
                     :data-id="orderQuestion.id">
                    <i class="fa fa-arrows"></i>
                    [% orderQuestion.name %]
                </div>
            </div>
        </div>
    </div>
</div>
