<?php
/**
 * Complimented item manage page
 *
 * @category Plugins
 * @package  Mtc_Plugins
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
namespace Mtc\Plugins\ComplimentedItems\Classes;

use Item;
use Util;

$path = '../../../';
require_once $path . 'core/includes/header.inc.php';

require_once '../admin/includes/install.php';

$page_meta['title'] = 'Complimented Items';

if (empty($_REQUEST['id']) || COMPLIMENTED_MAX < 1) {
    header('Location: /shop/admin/products/');
    exit();
}

$item_id = (int)$_REQUEST['id'];
$item = new Item($item_id);

// ------------------------ POST-BACK --------------------------
if (!empty($_POST['action'])
    && $_POST['action'] == 'update_complimented'
    && !empty($_POST['complimented'])
) {
    $update_items = array_filter($_POST['complimented'], function ($id) {
        return !empty($id);
    });

    ComplimentedItems::where('item_id', $item_id)
        ->delete();

    foreach ($update_items as $order => $update_item) {
        ComplimentedItems::create([
            'item_id' => $item_id,
            'complimented_item_id' => $update_item,
            'order' => $order
        ]);
    }
    $success = true;
}

// --------------------- END OF POST-BACK ----------------------

require_once $path . 'core/admin/templates/adminheader.html.php';
?>

<ul class="breadcrumbs el">
    <li>
        <a href="/admin/">
            Home
        </a> /
    </li>
    <li>
        <a href="/shop/admin/products/admin/">
            Manage Products
        </a> /
    </li>
    <li>
        <a href="/shop/admin/products/admin/item.php?id=<?= $item_id ?>">
            Edit Item
        </a> /
    </li>
    <li class="end">
        Manage Complimented Items
    </li>
</ul>
<h1>Manage Complimented items</h1>
<?php
require $path . 'shop/admin/products/tabnav.php';
if (!empty($success)) {
    echo showmsg('Items updated', 'success', $path);
}
?>
<form action="<?= Util::add_query_arg(['id' => $item_id]) ?>"
      method="post"
      class="style complimentedItems">
    <?php
    $complimented_items = ComplimentedItems::orderBy('order', 'ASC')
        ->where('item_id', $item_id)
        ->get();
    for ($i = 0; $i < COMPLIMENTED_MAX; $i++) {
        ?>
        <div class="row">
            <label for="complimented_<?= $i ?>_name">
                Item <?= $i + 1 ?>
            </label>
            <input type="hidden"
                   name="complimented[<?= $i ?>]"
                   id="complimented_<?= $i ?>"
                   value="<?= $complimented_items[$i]->complimented_item_id ?? '' ?>"
                   class="INPUT1"/>
            <input type="text"
                   id="complimented_<?= $i ?>_name"
                   value="<?= clean_page(item_name($complimented_items[$i]->complimented_item_id ?? null)) ?>"
                   class="INPUT1 short"/>
            <a class="browseComplimented btn" data-id="<?= $i ?>">
                Browse
            </a>
            <a class="btn cancel cancelComplimented" data-id="<?= $i ?>">
                Clear
            </a>
        </div>
        <?php
    }
    ?>
    <div class="row">
        <input type="hidden"
               name="action"
               value="update_complimented"/>
        <button type="submit"
                class="btn"
                name="submit">
            Save
        </button>
    </div>
</form>
<?php
require_once $path . 'core/admin/templates/adminfooter.html.php';
