<?php

namespace Mtc\Plugins\Wisebee\Classes\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\Modules\Members\Models\Member;

/**
 * Accessors
 *
 * @property int $id
 * @property int $wisebee_id
 * @property int $member_id
 * @property string $wisebee_token
 * @property string $updated_at
 * @property string $created_at
 *
 * @property Member $member
 */

class WisebeeMember extends Model
{
    protected $table = 'wisebee_members';

    protected $fillable = [
        'wisebee_id',
        'member_id',
        'wisebee_token',
    ];

    public function member(): BelongsTo
    {
        return $this->belongsTo(Member::class, 'member_id');
    }
}