<?php

use Mtc\Core\PaginationTemplate;
use Mtc\Core\Currency;

$path = './';
require_once $path . 'core/includes/header.inc.php';


if(!empty($_REQUEST['page'])) {
    $current_page = (int) $_REQUEST['page'];
}else{
    $current_page = 1;
}

$per_page = 12;
$offset = ($current_page - 1) * $per_page;

$filter = new ProductFilter();
$filter->max_per_page = $per_page;
$filter->page = $current_page;


// Online Doctor Categories
$categories = \Mtc\Shop\Category::query()
                ->active()
                ->where('hide', 0)
                ->where('deleted', 0)
                ->where('is_online_doctor', '1')
                ->get()
                ->map(function ($category) {
                    $category->url = $category->is_online_doctor ? $category->getDoctorLink() :  browse_url($category->id);
                    return $category;
                });

$cat_ids = $categories->map(function($category) {
    return $category->id;
});

if(!empty($cat_ids)) {
    $filter->selections['categories'] = $cat_ids->toArray();
}else{
    $filter->selections['categories'] = [];
}

$filter->setSortby('a-z');
$filter->start();


//Filter items
$items = [];
if (count($filter->items) > 0) {
    foreach ($filter->items as $item_id) {
        $item = new Item();
        $item->loadItemSmall($item_id);


        //if($item->product_type == 'doctor') {
            $items[] = $item;
        //}


    }
}



//Build items
$items = collect($items)->map(function($item){

    $temp_item = new Item();
    $temp_item->Get_Item($item->id);


    if(empty($temp_item->form_id) || $temp_item->form_id == '0') {

        $cids = [];

        foreach ($temp_item->categories as $c) {
            $cid    = (int) $c['cat_id'];
            $cids[] = $cid;
        }

        $category_ids = (new \Mtc\Shop\Category())->whereIn('id', (array) $cids)
                                                  ->get()
                                                  ->map(function ($cat) {
                                                      if (!empty($cat->form_id)
                                                          & $cat->form_id
                                                            != '0') {
                                                          return $cat;
                                                      }
                                                  })
        ;

        $last_category = collect($category_ids)->last();

        if (!empty($last_category)) {
            $item->form_category_id = $last_category->id;
        }


    }



    $main_category = collect($temp_item->categories)
        ->reject(function ($category) {
            return strtolower($category['name']) == "doctor" ||
                   strtolower($category['name']) == "pharmacy" ||
                   strtolower($category['name']) == "general" ||
                   strtolower($category['name']) == "shop";
        })->first();

    if(!empty($main_category['name'])) {
        $item->main_category = $main_category['name'];
    }else{
        $item->main_category = '';
    }

    return $item;
});


/*
 * Pagination
 */
if(!empty($search_term)) {
    $query_string = '?search_term=' . $search_term;
}else{
    $query_string = '';
}

$pagination = new PaginationTemplate([
    'item_count' => $filter->item_count,
    'per_page' => $per_page,
    'active_page' => $current_page,
    'show_view_all' => false,
    'show_next' => true,
    'show_previous' => true,
    'page_url' => '/treatments/' . $query_string,
]);

$pagination = $pagination->render($twig);


if($current_page > 1) {
    $twig->addGlobal('subtitle', 'Page ' . $current_page);
}

//Twig vars
$twig->addGlobal('items', $items);
$twig->addGlobal('pagination', $pagination);



