const path = require('path');
const mix = require('laravel-mix');

const site = {
    name: 'default'
};

mix.setPublicPath(path.resolve('./'));

mix
    .less(`sites/${site.name}/css/app.less`, 'public/css')
    .js(`sites/${site.name}/js/app.js`, 'public/js')
    .vue({
        version: 2,
        extractStyles: true  // ✅ updated way to extract styles from Vue components
    })
    .extract()
    .alias({
        '@site': path.join(__dirname, `sites/${site.name}`),
        '@core': path.join(__dirname, 'core')
    });

mix.options({
    processCssUrls: false // still valid here
});

// ✅ Global LESS variables/mixins injection
mix.webpackConfig({
    module: {
        rules: [
            {
                test: /\.less$/,
                oneOf: [
                    {
                        resourceQuery: /lang=less/,
                        use: [
                            {
                                loader: 'less-loader',
                                options: {
                                    lessOptions: {
                                        javascriptEnabled: true
                                    },
                                    additionalData: `
                                        @import "@site/css/variables.less";
                                        @import "@core/css/mixins.less";
                                        @import "@site/css/base/mixins.less";
                                    `
                                }
                            }
                        ]
                    }
                ]
            }
        ]
    }
});

mix.version();