<?php

namespace App;

use Page;
use Mtc\Shop\Category;


class CategoryPageHelper
{

    public static $category = null;

    private static $contact_page_id = 12;


    /*
     * Build all the data for use with category landing pages.
     */
    public static function getTemplateData(Category $category)
    {
        $template_data = [];

        $template_data['sub_categories'] = self::get_sub_categories($category);

        $template_data['hero_banner'] = self::hero_banner_block($category);
        $template_data['description_block'] = self::description_block($category);
        $template_data['category_faqs'] = self::category_faqs_block($category);
        $template_data['page_meta'] = self::get_meta_data($category);
        $template_data['key_points'] = self::get_key_points($category);
        $template_data['content_tabs'] = self::category_content_tabs($category);

        return $template_data;
    }



    /*
     * Get the sub categories
     * The sub categories will be displayed instead of items (eg /online-doctor/mens-health/)
     */
    private static function get_sub_categories(Category $category)
    {
        $sub_categories = MultisiteHelper::getCategoriesToDisplay($category->id, function($query) {
            $query
                ->where('is_online_doctor', true)
            ;
        });

        return $sub_categories;
    }


    /* CMS Style data */

    /*
     * Used to display content within the hero banner (includes/page_blocks/title_banner.twig)
     */
    private static function hero_banner_block(Category $category) {


        $hero_banner = [
            'Title' => [
                'value' => $category->display_name ?: $category->name
            ],
            'Subtitle' => [
                'value' => '', //$category->parent_category_name
            ],
            'Content' => [
                'value' => $category->description_small
            ]
        ];

        if(!empty($category->description_image)) {

            $alt = $category->description_image_alt;

            $hero_banner['Banner Image'] = [
                'value' => $category->image,
                'alt' => !empty($alt) ? $alt : $category->name . ' hero image',
                'path' => '/uploads/images/categories/category_banner/'
            ];

        }


       
        return $hero_banner;

    }

    /*
     * Used to display icons with key point text within the hero
     */
    private static function get_hero_icon_points(Category $category)
    {
        $icon_points = [];


        foreach ($category->display_tags->where('group_name', 'a') as $display_tag) {
            $icon_points[] = [
                    'icon' => $display_tag->icon ? $display_tag->icon->getFileUrl() : '',
                    'text' => $display_tag->label,
                ];
        }

        return $icon_points;
    }

    public static function get_key_points(Category $category = null)
    {
        $key_points = [];

        if ($category) {
            foreach ($category->display_tags->where('group_name', 'b') as $display_tag) {
                $key_points[] = [
                    'icon' => $display_tag->icon ? $display_tag->icon->getFileUrl() : '',
                    'text' => $display_tag->label,
                ];
            }
        }


        return $key_points;
    }

    /*
     * Used to display category information inside image banner (includes/image_banner.twig)
     * Displays description image, description title and description.
     * Binds overview, causes, symptoms and treatments content.
     */
    private static function description_block(Category $category) {

        $description_block = [];
        $category_content_tabs = self::category_content_tabs($category);

        if(!empty($category->description_title)) {
            $description_block['Title'] = [
                'value' => $category->description_title
            ];
        }

        if(!empty($category->description)) {
            $description_block['Content'] = [
                'value' => $category->description
            ];
        }

        if(!empty($category->description_image)) {

            $alt = $category->description_image_alt;

            $description_block['Banner Image'] = [
                'value' => $category->description_image,
                'alt'   => !empty($alt) ? $alt : $category->name . ' intro image'
            ];
        }

        //if(!empty($category_content_tabs)) {
            //$description_block['faqs'] = $category_content_tabs;
        //}

        return $description_block;

    }

    /*
     * Builds category content sections data
     * Structured for use within FAQs style accordion or general content tabs sections
     * Binds overview, causes, symptoms and treatments content for use within an accordion.
     */
    private static function category_content_tabs(Category $category) {

        $content_tabs = [];


        if(!empty($category->overview)) {
            $content_tabs[] = [
                'title'   => $category->overview_title ?: 'Overview',
                'content' => $category->overview
            ];
        }

        if(!empty($category->causes)) {
            $content_tabs[] = [
                'title'   => $category->causes_title ?: 'Causes',
                'content' => $category->causes
            ];
        }

        if(!empty($category->symptoms)) {
            $content_tabs[] = [
                'title'   => $category->symptoms_title ?: 'Symptoms',
                'content' => $category->symptoms
            ];
        }

        if(!empty($category->treatments)) {
            $content_tabs[] = [
                'title'   => $category->treatments_title ?: 'Treatments',
                'content' => $category->treatments
            ];
        }

        return $content_tabs;

    }


    /*
     * Used to display FAQs block within image banner (includes/image_banner.twig)
     * Displays FAQs image, FAQs title and FAQs intro.
     * Binds FAQS tabs for use with an accordion inside this block.
     */
    private static function category_faqs_block(Category $category) {

        $faqs_block = [];
        $faqs_tabs = self::category_faqs_tabs($category);

        if(!empty($category->faq_title)) {
            $faqs_block['Title'] = [
                'value' => $category->faq_title
            ];
        }

        if(!empty($category->faq)) {
            $faqs_block['Content'] = [
                'value' => $category->faq
            ];
        }


        if(!empty($category->faq_image)) {

            $alt = $category->faq_image_alt;

            $faqs_block['Banner Image'] = [
                'value' => $category->faq_image,
                'alt'   => !empty($alt) ? $alt : $category->name . ' FAQs intro image'
            ];
        }

        if(!empty($faqs_tabs)) {
            $faqs_block['faqs'] = $faqs_tabs;
        }

        return $faqs_block;

    }

    /*
     * Builds category FAQS
     * Structured for use within FAQs style accordion
     */
    private static function category_faqs_tabs(Category $category) {


        $category_faqs = [];

        if(!empty($category->faqs)) {

            foreach($category->faqs as $key => $faq) {

                if(!empty($faq->question) and !empty($faq->answer)) {

                    $category_faqs[] = [
                        'Title'   => ['value' => $faq->question],
                        'Content' => ['value' => $faq->answer]
                    ];

                }

            }

        }

        return $category_faqs;

    }


    /*
     * Meta data
     */
    private static function get_meta_data(Category $category)
    {
        $meta_data = [];

        $meta_data_factory = new MetaDataFactory($category);
        if ($meta_data_factory) {
            $meta_data['title'] = $meta_data_factory->getMetaTitle();
            $meta_data['description'] = $meta_data_factory->getMetaDescription();
        }

        return $meta_data;
    }

}
