<?php

namespace App\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Order;

class OrderRowPrintedEvent
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public string $role;
    public int $rowType;
    public Order|null $order;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(int $rowType, string $role, Order|null $order)
    {
        $this->role = $role;
        $this->rowType = $rowType;
        $this->order = $order;
    }

}
