<?php
/**
 * CMS Images
 *
 * Image folders must follow the format below.
 * The main $image_folders array is passed to Twig as a global variable
 *
 *
 *  $image_folders['unique_group_name'] = [
 *      'size_name' => [
 *          'path'                  => 'images/path',   // Path to images from public_html. No surrounding slashes.
 *          'width'                 => 2000,            // (optional if height is supplied) (int) If you provide a width but not the height it will resize the width and allow the height to strech however long
 *          'height'                => 2000,            // (optional if width is supplied) (int) If you provide a height but not the width it will resize the height and allow the width to strech however long
 *          'crop'                  => false,           // (optional) (default: true) (bool) Weather or not to crop image.
 *          'quality'               => 80,              // (optional) (default: 80) (int) Quality of the resized image.
 *          'crop_position'         => "middle"         // (optional) (default: middle) (string: top_left/top_center/top_right/middle_left/middle/middle_right/bottom_left/bottom_center/bottom_right)
 *                                                      // Position of the crop.
 *          'optimize_lossless'     => true             // (optional) (default: true) (bool) Allows to override IMAGE_OPTIMISE_LOSSLESS admin setting.
 *          'skip'                  => false            // (optional) (default: false) (bool) If true it will skip resizing this size. Used for "original" size
 *      ]
 *  ];
 *
 * For the recrop feature to work, the "originals" sub array must exist.
 * For recrop to work correctly all cropped images in an array must have the same aspect ratio.
 * A solution may be developed later for different aspect ratios.
 *
 */

$image_folders['cms_images'] = [
    "original" => [
        "path" => "uploads/images/cms/original",
        "skip" => true
    ],

    "small" => [
        "path" => "uploads/images/cms/small",
        "width" => 200,
        "height" => 100,
        "crop" => 1
    ],
    "medium" => [
        "path" => "uploads/images/cms/medium",
        "width" => 800,
        "height" => 400,
        "crop" => 1
    ],
    "gallery_large" => [
        "path" => "uploads/images/cms/gallery_large",
        "width" => 1000,
        "height" => 751,
        "crop" => 1
    ],
    "gallery_thumbs" => [
        "path" => "uploads/images/cms/gallery_thumbs",
        "width" => 767,
        "height" => 576,
    ],
    "group_image" => [
        "path" => "uploads/images/cms/group_image",
        "width" => 767,
        "height" => 575,
        "crop" => 1
    ],
];

/*
 * News listing and article images
 */

$image_folders['news_images'] = [
    "news_large" => [
        "path" => "uploads/images/cms/news_large",
        "width" => 1360,
        "height" => 765,
        "crop" => 1
    ],
    "news_image" => [
        "path" => "uploads/images/cms/news_image",
        "width" => 767,
        "height" => 575,
        "crop" => 1
    ],
    "news_thumb" => [
        "path" => "uploads/images/cms/news_thumb",
        "width" => 420,
        "height" => 300,
        "crop" => 1
    ],
];

$image_folders['cms_images']['news_large'] = $image_folders['news_images']['news_large'];
$image_folders['cms_images']['news_image'] = $image_folders['news_images']['news_image'];
$image_folders['cms_images']['news_thumb'] = $image_folders['news_images']['news_thumb'];
