<?php

$path = '../../../';
require_once $path.'core/includes/header.inc.php';

$page_meta['title'] = 'Manage SEO Categories';

$seoCategories = new SeoCategories();
$errors = array();

$form = array();

if ($_REQUEST['delete']) {
    $seoCategories->deleteCategory($_REQUEST['delete']);
    header('Location: manage.seo.categories.php?message=success');
    exit();
}

if ($_REQUEST['edit']) {
    $form = $seoCategories->getCategory($_REQUEST['edit']);
}

if ($_REQUEST['action'] == 'update') {
    $form['title'] = $_REQUEST['title'];
    $form['description'] = $_REQUEST['description'];

    if (count($errors) === 0) {
        $seoCategories->updateCategory($_REQUEST['id'], $_REQUEST['title'], $_REQUEST['description']);
        header('Location: manage.seo.categories.php?message=success');
        exit();
    }
}

if ($_REQUEST['action'] == 'csv') {
    if (!empty($_REQUEST['export'])) {
        header('Location: csv.get.php?type=categories');
        exit();
    } elseif (!empty($_REQUEST['import'])) {
        SeoCsv::importCsv('categories');
        header('Location: manage.seo.categories.php?message=success');
        exit();
    }
}

$categories = $seoCategories->getSeoCategories();

require_once $path . 'core/admin/templates/adminheader.html.php';
?>
<ul class="breadcrumbs el">
    <li><a href="/admin/">Home</a> /</li>
    <li><a href="/admin/seoadmin">Manage SEO</a> /</li>
    <li class="end"><?= clean_page($page_meta['title']) ?></li>
</ul>

<h1>SEO Categories</h1>

<?php
require_once 'tabnav.php';

if (count($errors) > 0) {
    showerrors($errors);
}
if (count($errors) == 0 && $_REQUEST['message'] == 'success') {
    echo showmsg("Operation carried out successfully", "success", $path);
}

require_once __DIR__.'/templates/csvform.html.php';
?>

<?php
if ($_REQUEST['edit']) {
?>
    <form action="<?= $_SERVER['PHP_SELF'] ?>" method="post" class="style">
        <fieldset>
            <div class="row">
                <label for="path">Brand</label>
                <?= clean_page($form['name']) ?>
                <input type="hidden" name="id" value="<?= clean_page($form['id']) ?>" />
            </div>
            <div class="row">
                <label for="title">Title</label>
                <input type="text" name="title" id="title" value="<?= clean_page($form['title']); ?>">
            </div>
            <div class="row">
                <label for="description">Description</label>
                <input type="text" name="description" id="description" value="<?= clean_page($form['description']); ?>">
            </div>
            <input type="hidden" name="action" value="update">

            <?php
            if ($_REQUEST['edit']) {
            ?>

                <input type="hidden" name="edit" value="<?= clean_page($_REQUEST['edit']) ?>">

            <?php
            }
            ?>

            <div class="search-button"><input type="submit" value="<?= (!$_REQUEST['edit']) ? 'Add' : 'Edit' ?>" class="BUTTON"/></div>
        </fieldset>
    </form>

<?php
}

if (!$_REQUEST['edit'] && count($categories) > 0) {
?>

    <table class="">
        <tr>
            <th class="center"></th>
            <th>Category</th>
            <th>Title</th>
            <th>Description</th>
            <th class="center"></th>
        </tr>
        <tbody class="tabular ui-sortable">

        <?php

        //outputting categories and sub categories
        echo $seoCategories->seoCategoryHelperPrintCategories($categories);
        ?>

        </tbody>
    </table>

<?php
}

require_once $path . 'core/admin/templates/adminfooter.html.php';
