<?php

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Event;

$tabs = [
    '/admin/seoadmin/manage.seo.php' => 'Manage',
    '/admin/seoadmin/manage.seo.defaults.php' => 'Defaults',
    '/admin/seoadmin/manage.seo.canonicals.php' => 'Canonical URLs',
    '/admin/seoadmin/manage.seo.redirects.php' => 'Redirects',
];

if (CMS_ENABLED) {
    $tabs['/admin/seoadmin/manage.seo.pages.php'] = 'Pages';
}

$tabs['/admin/seoadmin/manage.seo.headings.php'] = 'Headings';

// Add additional tabs by event.
$extra_tabs = Event::dispatch('core.admin.seoadmin.tabnav');

foreach ($extra_tabs as $extras) {
    // Confirm response is array
    if (false == is_array($extras)) {
        continue;
    }

    // If response's first item is not an array, put it in one.
    if (false == is_array(reset($extras))) {
        $extras = [$extras];
    }

    // Merge with parent tabs.
    foreach ($extras as $extra) {
        $tabs = array_merge($tabs, $extra);
    }
}

$tabs['/admin/seoadmin/manage.seo.help.php'] = 'Help';

?>
<ul class="tabnav el">
<?php
foreach ($tabs as $link => $title) {
    $selected = '';
    if (stristr($_SERVER['SCRIPT_NAME'], $link)) {
        $selected = 'class="selected"';
    }
    ?>
    <li <?= $selected; ?>>
        <a href="<?= $link; ?>"><?= clean_page($title); ?></a>
    </li>
    <?php
}

?>
</ul>
