<?php
/**
 * Fieldset list edit template
 *
 * @category Forms
 * @package  Mtc_Form_Builder
 * @author   mtc. Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
?>
<div class="fieldsetWrap clearfix">
    <div class="col side">
        <ul id="fieldsetList">
            <li v-for="fieldset in form.fieldsets">
                <a class="fieldsetListItem check_fieldset"
                   @click="changeFieldset(fieldset.id)"
                   :class="{
                        'active' : active_fieldset == fieldset.id
                   }"
                   :id="'fieldset_' + fieldset.id"
                   id="fieldset">
                    [% fieldset.name %]
                    <button type="submit"
                            :id="'removeFieldset_' + fieldset.id"
                            @click.prevent="removeFieldset(fieldset.id)"
                            class="noBtn removeFieldset check_fieldset"
                            value="Remove fieldset">
                        <i class="fa fa-trash"></i>
                    </button>
                </a>
            </li>
        </ul>
        <button type="submit"
                @click.prevent="addNewFieldset()"
                class="btn check_fieldset"
                id="addFieldset"
                name="add_fieldset"
                value="Add Fieldset">
            Add Fieldset
        </button>
    </div>
    <div class="col main"
         id="fieldsetContent"
         v-if="active_fieldset > 0">
        <?php
        include 'templates/fieldset.single.php';
        ?>
    </div>
</div>