Vue.component('patientAttributes', {

    props: [
        'attributes',
        'routes',
    ],

    data: function() {
        return {
            values: {},
            errors: {},
            loading: false,
            success: false,
            edit: false,
            initialValues: {}
        };
    },

    mounted: function() {
        this.init();
    },

    methods: {
        init() {
            this.loading = true;
            let vm = this;

            this.$http.post(this.routes['admin-member-attributes-load'], [])
                .then((response) => {

                    const data = response.data;

                    vm.values = data.attributes;
                    vm.initialValues = JSON.parse(JSON.stringify(data.attributes));

                    Object.keys(vm.attributes).forEach(key => {
                        let attribute = vm.attributes[key];
                        if (!(key in vm.values)) {

                            if (attribute.type === 'checkbox' && attribute.variations) {
                                vm.$set(vm.values, key, []);
                            } else {
                                vm.$set(vm.values, key, null);
                            }

                            if (attribute.type === 'datetime') {
                                vm.$set(vm.values, key + '_time', null);
                            }
                        }
                    });
                    this.setMarkupValues();
                    vm.loading = false;

                    this.$nextTick(function () {

                    });
                });
        },
        store() {
            if (this.loading) {
                return;
            }
            this.errors = {};
            this.success = false;
            this.loading = true;
            this.getMarkupValues();

            let vm = this;

            this.$http.post(this.routes['admin-member-attributes-store'], {
                attributes: { ...this.values },
            })
                .then((response) => {

                    const data = response.data;

                    if (data.errors) {
                        vm.errors = data.errors;
                    }
                    if (data.success) {
                        vm.success = data.success;
                    }
                    vm.loading = false;
                    vm.initialValues = JSON.parse(JSON.stringify(vm.values));
                });
        },
        getMarkupValues() {
            Object.keys(this.attributes).forEach(key => {
                let attribute = this.attributes[key];

                // Non-reactive fields
                if (['date', 'datetime'].includes(attribute.type)) {
                    this.values[key] = $('#attribute_' + key).val()
                }
                // Non-reactive fields
                if (['textarea'].includes(attribute.type)) {
                    this.values[key] = tinyMCE.get('attribute_' + key).getContent();
                }
            });
        },
        setMarkupValues() {
            Object.keys(this.attributes).forEach(key => {
                let attribute = this.attributes[key];
                if (['date', 'textarea', 'datetime'].includes(attribute.type)) {
                    $('#attribute_' + key).val(this.values[key])
                }
            });
        },
        toggleEdit(editMode) {
            if (!editMode) {
                this.getMarkupValues();
            } else {
                $('.patientAttributesTextarea').each((i, el) => {
                    simpleTinymceNew($(el));
                });
            }
            this.edit = !this.edit;

            // Cancel edit and reset form values
            if (!editMode) {
                this.values = JSON.parse(JSON.stringify(this.initialValues));
            }
        },
        getValue(key) {
            if (typeof this.values[key] === 'undefined') {
                return '';
            }
            if (this.attributes[key].type === 'datetime') {
                return this.values[key] + ' ' + this.values[key + '_time'];
            }
            if (this.attributes[key].type === 'checkbox' && this.attributes[key].variations) {
                return this.values[key].join(',<br />')
            }
            return this.values[key];
        }
    },
});
