<?php
if (empty($path)) {
    $path = '../../../';
    require_once $path . 'core/includes/header.inc.php';
    $display_message = true;
}

/**
 * Install file for Member Messenger
 *
 * @author Matiss Bisofs <matiss.bisofs@mtcmedia.co.uk>
 */

use Illuminate\Database\Capsule\Manager as Capsule;

$schema = Capsule::connection()->getSchemaBuilder();


// create tables

$tables = [
    'messenger_threads' => [
        'fields' => function($table){
            $table->increments('id')->unsigned;
            $table->string('url');
            $table->timestamps();
            $table->softDeletes();
        }
    ],

    'messenger_participants' => [
        'fields' => function($table){
            $table->increments('id')->unsigned;
            $table->integer('member_id');
            $table->integer('thread_id');
            $table->timestamps();
        }
    ],

    'messenger_messages' => [
        'fields' => function($table){
            $table->bigIncrements('id')->unsigned;
            $table->integer('member_id');
            $table->integer('thread_id');
            $table->text('text');
            $table->timestamps();
            $table->softDeletes();
        }
    ],

    'messenger_messages_read' => [
        'fields' => function($table){
            $table->bigIncrements('id')->unsigned;
            $table->integer('member_id');
            $table->integer('message_id');
            $table->integer('thread_id');
            $table->dateTime('read_at');
            $table->timestamps();
        }
    ],
];

foreach($tables as $table_name => $table_data) {
    if ($schema->hasTable($table_name) === false) {
        $schema->create($table_name, function($table) use ($table_data){
            $table_data['fields']($table);
        });
    }
}

/*
 * Create the admin menu item
 *
 * Currently added under "Mtc Only" menu but could be given to clients
 */
//
//$setting_check = Capsule::table("admin_menu")->where('constant', 'SHARE_BUTTONS_INSTALLED')->exists();
//
//if (empty($setting_check)) {
//
//    Capsule::table('admin_menu')->insert(
//        [
//            'sub_id' => 1,
//            'title' => 'Share Buttons',
//            'path' => $path_to_admin_folder,
//            'activePath' => $path_to_admin_folder,
//            'constant' => 'SHARE_BUTTONS_INSTALLED',
//            'icon' => 'fa fa-share-alt',
//            'new_window' => 0,
//            'order' => 2,
//        ]
//    );
//
//}
//
/*
 * Mark plugin as installed
 *
 * This plugin is never really enabled or disabled this flag
 * is only used to track if it has its settings in place to
 * skip installation from being run again.
 */
$data = [
    [
        'key' => 'MESSENGER_INSTALLED',
        'type' => 'bool',
        'value' => 1,
        'module' => 'MEMBERS_MESSAGING',
        'description' => 'Install setting flag for Member Messaging',
        'created_at' => new DateTime(),
    ],
    [
        'key' => 'MAX_MEMBERS_PER_CHAT',
        'type' => 'int',
        'value' => 2,
        'module' => 'MEMBERS_MESSAGING',
        'description' => 'Defines the maximum amount of members allowed per chat',
        'created_at' => new DateTime(),
    ],
    [
        'key' => 'MESSAGES_PER_LOAD',
        'type' => 'int',
        'value' => 20,
        'module' => 'MEMBERS_MESSAGING',
        'description' => 'Defines the amount of messages to show per request',
        'created_at' => new DateTime(),
    ],
];

foreach ($data as $key => $values) {
    if (defined($values['key'])) {
        unset($data[$key]);
    }
}

MTC\Core\Setting::Insert($data);

if ($display_message === true) {
    exit('Install successful');
}
