<?php
/**
 * CMS Images
 *
 * Image folders must follow the format below.
 * The main $image_folders array is passed to Twig as a global variable
 *
 *
$image_folders['unique_name'] = [
'originals' => [
'path' => 'images/path/',
'width' => 2000,
'height' => 2000,
'forced' => false,
'crop' => false
]
];
 *
 * For the recrop feature to work, the "originals" sub array must exist.
 * For recrop to work correctly all cropped images in an array must have the same aspect ratio.
 * A solution may be developed later for different aspect ratios.
 *
 */

$image_folders['signature'] = [
    'originals' => [
        'path' => 'uploads/images/signature/originals',
        'width' => 1200,
        'height' => 1200,
        'forced' => false,
        'crop' => false
    ],
    'normal' => [
        'path' => 'uploads/images/signature',
        'width' => 500,
        'height' => 250,
        'forced' => false,
        'crop' => true
    ],
    'thumb' => [
        'path' => 'uploads/images/signature/thumbs',
        'width' => 200,
        'height' => 100,
        'forced' => false,
        'crop' => true
    ]
];

$image_folders['category_images'] = [
    "category_icon" => [
        "path" => "uploads/images/categories/icon",
        "width" => 438,
        "height" => 438,
        "crop" => 1,
        "forced" => true,
    ],
    'originals' => [
        'path' => 'uploads/images/categories/originals',
        'width' => 1200,
        'height' => 1200,
        'forced' => false,
        'crop' => false
    ],
    'category_banner' => [
        'path' => 'uploads/images/categories/category_banner',
        'width' => 1686,
        'height' => 794,
        'forced' => true,
        'crop' => false
    ],
    'normal' => [
        'path' => 'uploads/images/categories',
        'width' => 2000,
        'height' => 778,
        'forced' => true,
        'crop' => false
    ],
    'thumbs' => [
        'path' => 'uploads/images/categories/thumbs',
        'width' => 275,
        'height' => 204,
        'forced' => true,
        'crop' => true
    ],
    'thumbs_box' => [
        'path' => 'uploads/images/categories/thumbs_box',
        'width' => 400,
        'height' => 400,
        'forced' => true,
        'crop' => true
    ],
    'cards' => [
        'path' => 'uploads/images/categories/cards',
        'width' => 448,
        'height' => 208,
        'forced' => true,
        'crop' => true
    ],
    'cards_medium' => [
        'path' => 'uploads/images/categories/cards_medium',
        'width' => 454,
        'height' => 208,
        'forced' => true,
        'crop' => true
    ],
    'cards_small' => [
        'path' => 'uploads/images/categories/cards_small',
        'width' => 468,
        'height' => 206,
        'forced' => true,
        'crop' => true
    ],
    'cards_landscape' => [
        'path' => 'uploads/images/categories/cards_landscape',
        'width' => 402,
        'height' => 298,
        'forced' => true,
        'crop' => true
    ],
    "title_banner" => [
        "path" => "uploads/images/categories/title_banner",
        "width" => 690,
        "height" => 900,
        "forced" => true,
        "crop" => true
    ],
    "title_banner_tall" => [
        "path" => "uploads/images/categories/title_banner_tall",
        "width" => 520,
        "height" => 600,
        "forced" => true,
        "crop" => true
    ],
    "title_banner_mobile" => [
        "path" => "uploads/images/categories/title_banner_mobile",
        "width" => 682,
        "height" => 340,
        "forced" => true,
        "crop" => true
    ],
    "image_banner_desktop" => [
        "path" => "uploads/images/cms/image_banner_desktop/",
        "width" => 900,
        "height" => 550,
        "forced" => true,
        "crop" => 1
    ],
    "image_banner_desktop_small" => [
        "path" => "uploads/images/cms/image_banner_desktop_small/",
        "width" => 600,
        "height" => 370,
        "forced" => true,
        "crop" => 1
    ],
    "image_banner_mobile" => [
        "path" => "uploads/images/cms/image_banner_mobile/",
        "width" => 698,
        "height" => 558,
        "forced" => true,
        "crop" => 1
    ]
];

$image_folders['category_thumb_images'] = [
    'originals' => [
        'path' => 'uploads/images/categories_thumbs/originals',
        'width' => 1200,
        'height' => 1200,
        'forced' => false,
        'crop' => false
    ],
    'home_image' => [
        'path' => 'uploads/images/categories_thumbs/home_image',
        'width' => 315,
        'height' => 197,
        'forced' => true,
        'crop' => true
    ],
];

$image_folders['brand_images'] = [
    'originals' => [
        'path' => 'uploads/images/brands/originals',
        'width' => 1200,
        'height' => 1200,
        'forced' => false,
        'crop' => false
    ],
    'small' => [
        'path' => 'uploads/images/brands/small',
        'width' => null,
        'height' => 100,
        'forced' => false,
        'crop' => false
    ],
    'normal' => [
        'path' => 'uploads/images/brands/normal',
        'width' => 1160,
        'height' => 349,
        'forced' => false,
        'crop' => true
    ],
];

$image_folders['brand_logos'] = [
    'originals' => [
        'path' => 'uploads/images/brand_logos/originals',
        'width' => 700,
        'height' => 350,
        'forced' => false,
        'crop' => false
    ],
    'small' => [
        'path' => 'uploads/images/brand_logos/small',
        'width' => 140,
        'height' => 70,
        'forced' => false,
        'crop' => false
    ],
    'normal' => [
        'path' => 'uploads/images/brand_logos/normal',
        'width' => 280,
        'height' => 140,
        'forced' => false,
        'crop' => false
    ]
];

$image_folders['product_folders'] = [
    'originals' => [
        'path' => 'uploads/images/products/originals',
        'width' => 1200,
        'height' => 1200,
        'forced' => false,
        'crop' => false
    ],
    'mini' => [
        'path' => 'uploads/images/products/mini',
        'width' => 63,
        'height' => 63,
        'forced' => false,
        'crop' => false
    ],

    'orders_thumb' => [
        'path' => 'uploads/images/products/orders_thumb',
        'width' => 74,
        'height' => 74,
        'forced' => false,
        'crop' => false
    ],

    'smallthumbs' => [
        'path' => 'uploads/images/products/smallthumbs',
        'width' => 100,
        'height' => 100,
        'forced' => false,
        'crop' => false
    ],

    'thumbs' => [
        'path' => 'uploads/images/products/thumbs',
        'width' => 400,
        'height' => 400,
        'forced' => true,
        'crop' => false
    ],

    'mobile' => [
        'path' => 'uploads/images/products/mobile',
        'width' => 324,
        'height' => 234,
        'forced' => false,
        'crop' => false
    ],

    'mobile_box' => [
        'path' => 'uploads/images/products/mobile_box',
        'width' => 324,
        'height' => 324,
        'forced' => false,
        'crop' => false
    ],

    'large' => [
        'path' => 'uploads/images/products/large',
        'width' => 1222,
        'height' => 1222,
        'forced' => true,
        'crop' => false
    ],

    'large_box' => [
        'path' => 'uploads/images/products/large_box',
        'width' => 648,
        'height' => 648,
        'forced' => true,
        'crop' => false
    ],

    'verylarge' => [
        'path' => 'uploads/images/products/verylarge',
        'width' => 1200,
        'height' => 1200,
        'forced' => true,
        'crop' => false
    ],
];

$image_folders['custom_folders'] = [
    'originals' => [
        'path' => 'uploads/images/custom/originals',
        'width' => 1200,
        'height' => 1200,
        'forced' => false,
        'crop' => false
    ],
    'normal' => [
        'path' => 'uploads/images/custom/normal',
        'width' => 300,
        'height' => 300,
        'forced' => false,
        'crop' => false
    ],
];
