$(document).ready(function () {
    if($('.mainMenu').length) {
        showHideMenus('.mainMenu .hasChildren > a', 1120);
    }

    showSidebarMenus()
});

$(window).on('resize', debouncer(function (e) {
    if($('.mainMenu').length) {
        showHideMenus('.mainMenu .hasChildren > a', 1120);
    }
})); // debounce

/*
 * Trigger section below breakpoint. Selector is the trigger
 */

window.showHideMenus = function(selector, breakpoint) {
    'use strict';

    const $selector = $(selector);

    $selector.each(function(){
        const trigger = $(this);
        let section = trigger.next();

        if (typeof (trigger.data('target')) !== 'undefined') {
            section = $(trigger.data('target'));
        }

        if(section.length > 0 && !trigger.hasClass('directLink')) {
            // mobile: show / hide behaviour
            if (matchesMediaQuery(0, breakpoint) && !trigger.hasClass('isClickable')) {

                // initialise show / hide state
                section.hide();
                trigger.addClass('isClickable');
                // bind click
                $(trigger).on('click', function (e) {

                    var this_section = $(this).next(),
                        this_trigger = $(this);

                    e.preventDefault();

                    if (typeof (this_trigger.data('target')) !== 'undefined') {
                        this_section = $(this_trigger.data('target'));
                    }

                    this_section.toggleClass('open').stop(true, true).slideFadeToggle();
                    this_trigger.toggleClass('open');
                });

            } else if (matchesMediaQuery(Number(breakpoint + 1)) && trigger.hasClass('isClickable')) {
                trigger.removeClass('isClickable');
                // disable click and remove classes
                trigger.removeClass('open').off('click');
                section.removeClass('open').css({
                    display: ''
                });
            }
        }
    });
}

window.addEventListener('DOMContentLoaded', function(event) {
    'use strict';

    if($('.megaMenuWrapper').length) {
        $('.megaMenuWrapper').addClass('menuReady');
    }
});


const showSidebarMenus = () => {
    $('.treatments .hasChildren > a > button, .treatments .hasChildren > .dropdownWrap > button').on('click', function (event) {
        event.preventDefault();

        const $parent = $(this).closest('.hasChildren');
        const isOpeningButton = $(this).closest('a').length > 0;

        if (isOpeningButton) {
            $parent.addClass('open');
        } else {
            $parent.removeClass('open');
        }
    });
}