$(function () {
    const $wrap = $('.partners__wrap');
    const $list = $wrap.find('.partners__list');
    const scrollSpeed = 1;
    const interval = 16;
    const resumeDelaySec = 2; // seconds
    let scrollInterval = null;
    let resumeTimeout = null;
    let isUserScrolling = false;

    // Clone list for seamless scroll
    const $clone = $list.clone();
    $clone.addClass('partners__list--clone');
    $wrap.append($clone);

    $clone.css('left', $list.width());

    const startScroll = () => {
        if (scrollInterval) return;
        scrollInterval = setInterval(() => {
            $wrap.scrollLeft($wrap.scrollLeft() + scrollSpeed);
        }, interval);
    };

    const stopScroll = () => {
        clearInterval(scrollInterval);
        scrollInterval = null;
    };

    const pauseAndResume = () => {
        stopScroll();
        clearTimeout(resumeTimeout);
        resumeTimeout = setTimeout(() => {
            isUserScrolling = false;
            startScroll();
        }, resumeDelaySec * 1000);
    };

    $wrap.on('mouseenter', () => {
        stopScroll();
        clearTimeout(resumeTimeout);
    });

    $wrap.on('mouseleave', () => {
        pauseAndResume();
    });

    // Mobile/touch: pause on user scroll/touch, resume after delay
    $wrap.on('touchstart', () => {
        isUserScrolling = true;
        stopScroll();
        clearTimeout(resumeTimeout);
    });

    $wrap.on('touchend', () => {
        pauseAndResume();
    });

    // Always handle infinite scroll, even on manual scroll
    $wrap.on('scroll', () => {
        const listWidth = $list.width();
        if ($wrap.scrollLeft() >= listWidth) {
            $wrap.scrollLeft($wrap.scrollLeft() - listWidth);
        }
        if (isUserScrolling) {
            stopScroll();
            clearTimeout(resumeTimeout);
            resumeTimeout = setTimeout(() => {
                isUserScrolling = false;
                startScroll();
            }, resumeDelaySec * 1000);
        }
    });

    startScroll();
});