<?php

use App\MultisiteHelper;
use Mtc\Shop\Category;
use Mtc\Core\PaginationTemplate;

function buildCategoryTree(int $parentId, callable $modifyQuery, int $maxDepth = 2)
{
    if ($maxDepth < 1) {
        return collect();
    }

    $categories = MultisiteHelper::getCategoriesToDisplay($parentId, $modifyQuery);

    foreach ($categories as $category) {
        $category->children = buildCategoryTree($category->id, $modifyQuery, $maxDepth - 1);
    }

    return $categories;
}

$twig_variables['category_tree'] = buildCategoryTree(
    0,
    function ($query) {
        $query->where('is_online_doctor', true);
    },
    3
);