const path = require('path');
const mix = require('laravel-mix');

const site = {
    name: 'default'
};

mix.setPublicPath(path.resolve('./'));

mix
    .less('sites/' + site.name + '/css/app.less', 'public/css')
    .js('sites/' + site.name + '/js/app.js', 'public/js')
    .vue({ version: 2 })
    .extract() //Use this to break into manifest.js, vendor.js and app.js (Will require the extra scripts are added to template)
    .alias({
        '@site': path.join(__dirname, 'sites/' + site.name),
        '@core': path.join(__dirname, 'core')
    });

mix.version();
