# Pinned Items 

This package creates a dynamic list for pinning items. This can be pinned pages,
pinned articles, products or anything else that is an eloquent model.

# Installation

```bash
composer require mtcmedia/pinned-items

php artisan migrate
```

# Usage

```php
use Mtc\PinnedItems\Facades\PinnedItems;
// $viewer - object that 
$owner = Auth::user();
// $model_to_pin - any eloquent object to Pin
$model_to_pin = Page::find(1);
// $category - string for specifying how to group items. Allows pinned items to be used across different models 
$category = 'pages';
$limit = 3;

PinnedItems::add($owner, $model_to_pin, $category);

PinnedItems::remove($owner, $model_to_pin, $category);

$items_viewed = PinnedItems::get($owner, $category, $limit);
```
