<?php

namespace Mtc\PinnedItems;

use Illuminate\Support\ServiceProvider;

class PinnedItemProvider extends ServiceProvider
{
    /**
     * Register service
     */
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__) . '/config/pinned_items.php', 'pinned_items');
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/migrations');
        $this->app->bind(PinnedItemRepository::class, function () {
            return new PinnedItemRepository(config('pinned_items'));
        });

        $this->app->bind('pinned-items', PinnedItemRepository::class);
    }
}
