<?php

namespace Mtc\PinnedItems\Facades;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Facade;
use Mtc\PinnedItems\PinnedItemRepository;

/**
 * Class PinnedItem
 *
 * @method static void add(Model $owner, Model $viewed, string $category = null)
 * @method static void addUrl(Model $owner, string $url, string $category = null)
 * @method static void remove(Model $owner, Model $viewed, string $category = null)
 * @method static void removeUrl(Model $owner, string $url, string $category = null)
 * @method static Collection get(Model $owner, string $category = null, int $count = null)
 * @see PinnedItemRepository
 */
class PinnedItems extends Facade
{
    protected static function getFacadeAccessor()
    {
        return 'pinned-items';
    }
}
