<?php

namespace Mtc\PinnedItems;

use Illuminate\Support\ServiceProvider;

class PinnedItemProvider extends ServiceProvider
{
    /**
     * Register service
     */
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__) . '/config/pinned_items.php', 'pinned_items');
        if (config('pinned_items.load_migrations')) {
            $this->loadMigrationsFrom(dirname(__DIR__) . '/database/migrations');
        }
        $this->app->bind(PinnedItemRepository::class, function () {
            $class = config('pinned_items.repository');
            return new $class(config('pinned_items'));
        });

        $this->app->bind('pinned-items', config('pinned_items.repository'));

        $this->publishes([
            dirname(__DIR__) . '/database/migrations' => $this->app->databasePath('migrations'),
        ], 'migrations');
    }
}
