<?php
/**
 * Illuminate/Routing
 *
 * @source https://github.com/illuminate/routing
 * @contributor Muhammed Gufran
 * @contributor Matt Stauffer
 * @contributor https://github.com/jwalton512
 * @contributor https://github.com/dead23angel
 */

use Illuminate\Container\Container;
use Illuminate\Events\Dispatcher;
use Illuminate\Http\Request;
use Illuminate\Routing\Router;

define('LARAVEL_START', microtime(true));
$path = './';
require_once $path .  'core/includes/header.inc.php';

// Create a service container
$container = new Container;

// Create a request from server variables, and bind it to the container; optional
$request = Request::capture();
$container->instance('Illuminate\Http\Request', $request);

// Using Illuminate/Events/Dispatcher here (not required); any implementation of
// Illuminate/Contracts/Event/Dispatcher is acceptable
$events = new Dispatcher($container);
/** @var Router $router */
$router = \Illuminate\Support\Facades\App::make(Router::class);

\Illuminate\Support\Facades\App::instance('page_meta', $page_meta);
\Illuminate\Support\Facades\App::instance('image_folders', $image_folders);
\Illuminate\Support\Facades\App::instance('cache', $cache);

/** @var \Illuminate\Contracts\Http\Kernel $kernel */
$kernel = \Illuminate\Support\Facades\App::make(Illuminate\Contracts\Http\Kernel::class);

$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

if ($response->getStatusCode() == 404) {
    require_once SITE_PATH . '/core/includes/legacy.php';
    require_once $path . 'core/index.php';
    exit;
}
$response->send();

$kernel->terminate($request, $response);
