/**
 * We'll load jQuery and the Bootstrap jQuery plugin which provides support
 * for JavaScript based Bootstrap features such as modals and tabs. This
 * code may be modified to fit the specific needs of your application.
 */

window.$ = window.jQuery = require('jquery');

/**
 * Vue is a modern JavaScript library for building interactive web interfaces
 * using reactive data binding and reusable components. Vue's API is clean
 * and simple, leaving you to focus on building your next great project.
 */
window.Vue = require('vue');

// Load VeeValidate
require('./validate');

import VueLocalStorage from 'vue-localstorage'
Vue.use(VueLocalStorage);

require('vue-resource');
window.vueEventHub = new Vue();

// amends to vue resource for our archaic server setup
Vue.http.options.emulateJSON = true;
Vue.http.interceptors.unshift(function(request, next) {
    next(function(response) {
        if(typeof response.headers['content-type'] != 'undefined') {
            response.headers['Content-Type'] = response.headers['content-type'];
        }
    });
});

/**
 * Load global functions used across all platform
 * These functions are widely used to ensure consistent functionality
 */
require('../../core/js/functions.js');

Vue.directive('overlay', require('./directives/overlay').default);
Vue.component('date-picker', require('./components/date_picker').default);
Vue.component('vue-select', require('./components/chosen').default);
Vue.component('multi-currency-price', require('./components/multi_currency_price.vue').default);
