<?php
/**
 * Hooks Adapter
 *
 * A simple adapter for the Hooks class (class.hooks.php)
 * This converts all calls to the hooks class to a static class rather than
 * dealing with having initiate and use globals.
 *
 * @author  Craig McCreath <craig@mtcmedia.co.uk>
 * @deprecated
 */
class HooksAdapter
{
    /**
     * Storage of the Hooks instance
     * @access protected
     * @var $instance
     */
    protected static $instance = null;

    /**
     * Magic Method for missing static constants.
     * We use this to call the same methods as Hooks as a static argument.
     *
     * @param  $name The name of the missing method
     * @param  $arguments List of arguments passed to the method
     */
    public static function __callStatic($name, Array $arguments = [])
    {
        self::buildInstance();
        if (method_exists(self::$instance, $name)) {
            return call_user_func_array([self::$instance, $name], $arguments);
        }
    }

    /**
     * Build an instance of the Hooks class
     * @return void
     */
    public static function buildInstance()
    {
        if (self::$instance === null) {
            self::$instance = new Hooks();
        }
    }

}
