<?php
/**
 * Main Core Controller
 *
 * @author  Andrew Morgan <andrew.morgan@mtcmedia.co.uk>
 * @version 0.1
 */
require_once $path."core/includes/header.inc.php";

// sitemap redirect
if ($_SERVER['REQUEST_URI'] == "/sitemap.xml") {
    header("Location: " . THEME_PATH . "/generator/sitemap.xml");
    die();
}

// initialise SEO Admin
$seoadmin = new Seo();

if (defined('CMS_ENABLED') && CMS_ENABLED === true) {
    include_once $path . 'cms/index.php';
}

$seoadmin->getSeoData();

// allow SEO admin to override page title and description if available
if (!empty($seoadmin->data['title'])) {
    $page_meta['title'] = $seoadmin->data['title'];
}

if (!empty($seoadmin->data['description'])) {
    $page_meta['description'] = $seoadmin->data['description'];
}

// add canonical url if available
if (isset($seoadmin->data['canonical_path']) && !empty($seoadmin->data['canonical_path'])) {
    $page_meta['canonical'] = $seoadmin->data['canonical_path'][0];
}

if (defined('BREADCRUMBS') && BREADCRUMBS === true) {
    if (is_array($breadcrumbs)) {
        array_unshift($breadcrumbs, [
            'url' => '/',
            'name' => 'Home',
        ]);
        if (defined('BREADCRUMBS_LINK_LAST_CRUMB') && BREADCRUMBS_LINK_LAST_CRUMB === false) {
            $breadcrumbs[count($breadcrumbs) - 1]['url'] = null;
        }
    }
}

$page_meta['page_template'] = 'content.twig';
$page_meta['layout'] = 'default.twig';

$args = [
    isset($p) ? $p : null,
    &$page_meta,
    &$twig_variables,
    &$breadcrumbs
];

HooksAdapter::do_action_ref_array('set_page_settings', [$args]);

$twig_variables['page_meta'] = $page_meta;


if (defined('BREADCRUMBS') && BREADCRUMBS === true) {
    $twig->addGlobal('breadcrumbs', $breadcrumbs);
}

/**
 * Check if page caching is set
 * TODO : Change to just CACHE_PAGES as caching should be handled by core.
 */
if (defined('CMS_HTML_CACHE_PAGES') && CMS_HTML_CACHE_PAGES === true) {
    $cache_html = true;
} elseif (!isset($cache_html)) {
    $cache_html = false;
}

if ($cache_html === true) {
    ob_start();
}

// Render the page
echo $twig->render(
    'pages/' . $page_meta['page_template'],
    $twig_variables
);

if ($cache_html === true) {

    $page_html = ob_get_contents();
    ob_end_flush();

    $cache_disclaimer = "<!--CACHE FOR PAGE ID:"
        . $p->id . " SLUG:"
        . $p->slug . " GENERATED ".date("d/m/Y H:i:s")
        . " -->";

    if ($not_found_page === true) {
        $cache_file_path = SITE_PATH . THEME_PATH . "/" . $p->slug . ".html";
    } else {
        $cache_file_path = SITE_PATH . THEME_PATH . "/cache/" . $p->id . ".html";
    }

    $fw = fopen($cache_file_path, "w");

    fputs(
        $fw,
        $page_html . $cache_disclaimer,
        strlen($page_html . $cache_disclaimer)
    );

    fclose($fw);

}
