function mtcLoadImage(element) {
    'use strict';

    var image,
        media,
        image_to_load,
        parent_class,
        parent_title;

    image = new Image();
    image.parent_element = element;

    if (element.hasClass('js_pictureReplace')) { // picture tag replace
        image_to_load = element.find('.js_imgTag').data('src'); // finds classes defined src
        image.element_src = image_to_load;

        element.find('source').each(function () {
            // Each source tag who matches pointed media query srcset is replaced
            media = $(this).attr('media');
            if (window.matchMedia(media).matches) {
                image_to_load = $(this).attr('srcset');
                return false;
            }
        });

        image.onload = function () {
            var replaced_element,
                element_tag,
                image_alt,
                image_title,
                image_class;

            this.parent_element.removeClass('js_imageReplace').removeClass('js_pictureReplace').removeClass('imageLoading');
            parent_class = (this.parent_element.attr('class')) ? ' class="' + this.parent_element.attr('class') + '" ' : '';
            replaced_element = $(
                '<picture ' +
                parent_class + '></picture>').html(this.parent_element.html());
            this.parent_element.after(replaced_element).remove();
            element_tag = replaced_element.find('.js_imgTag');
            element_tag.removeClass('js_imgTag');
            image_alt = (element_tag.attr('data-alt')) ? ' alt="' + element_tag.attr('data-alt') + '" ' : '';
            image_title = (element_tag.attr('title')) ? ' title="' + element_tag.attr('title') + '" ' : '';
            image_class = (element_tag.attr('class')) ? ' class="' + element_tag.attr('class') + '" ' : '';
            element_tag.replaceWith('<img ' +
                'src="' + this.element_src + '" ' +
                image_alt +
                image_title +
                image_class +
                '/>');
            // call picture fill manually because of ie11
            replaced_element.fadeIn();
        };
        image.onerror = function () {
            this.parent_element.remove();
        };
        image.src = image_to_load;
    } else { // img tag replace
        image.onload = function () {
            var replaced_element,
                parent_class;
            this.parent_element.removeClass('js_imageReplace').removeClass('imageLoading');
            parent_class = (this.parent_element.attr('class')) ? ' class="' + this.parent_element.attr('class') + '" ' : '';
            parent_title = (this.parent_element.attr('title')) ? ' title="' + this.parent_element.attr('title') + '" ' : '';

            replaced_element = $('<img ' +
                'src="' + this.parent_element.data('src') + '" ' +
                'alt="' + this.parent_element.attr('data-alt') + '" ' +
                parent_class +
                parent_title +
                'style="display:none;"' +
                '/>');

            this.parent_element.after(replaced_element).remove();
            replaced_element.fadeIn();
        };
        image.onerror = function () {
            this.parent_element.remove();
        };
        image.src = element.data('src');
    }
}

function mtcImageReplace() {
    'use strict';

    $('.js_imageReplace').each(function (index, el) {
        var $_this = $(this);

        if (isElementInViewport(el)) {
            mtcLoadImage($_this);
        }
    });
}

function loadifySlider() {
    'use strict';

    if ($('.sliderWrap ul li').length > 1) {

        $('.slider')
            .on('init', function(event, slick) {
                $('.sliderWrap .skipVisibilityCheck').removeClass('skipVisibilityCheck');
            })
    }
}

$(document).ready(function () {
    'use strict';

    if ($('.js_imageReplace').length > 0) {
        mtcImageReplace();

        $(window).on('scroll', function (e) {
            if (!window.loadify_timeout) {
                window.loadify_timeout = true;
                mtcImageReplace();
                window.loadify_timeout = false;
            }
        });

        $('body').on('swipe', '.slick-slider', function () {
            mtcImageReplace();
        });

        $('body').on('beforeChange', '.slick-slider', function (event, slick) {

            // Set's timeout because on this callback init slick can't find slick-active
            setTimeout(function () {
                slick.$slides.filter('.slick-active').find('.js_imageReplace').each(function (i, el) {
                    mtcLoadImage($(el));
                });
             }, 10);
        });

        $('body').on('afterChange', '.slick-slider', function (event, slick) {

            // Set's timeout because on this callback init slick can't find slick clone
            setTimeout(function () {
                mtcImageReplace();
            }, 10);
        });
    }

    loadifySlider();

}); // window ready

$(window).on('resize', debouncer(function (e) {
    'use strict';

    if ($('.js_imageReplace').length > 0) {
        mtcImageReplace();
    }

    loadifySlider();

})); // debounce
