<?php

/**
 * Switch development mode on/off
 * @const DEV_MODE
 */
define('DEV_MODE', config('app.env') !== 'production');
define('ENVIRONMENT', config('app.env'));
define('SITE_NAME', config('app.name'));


/**
 * MySQL settings
 */
$db_environment = config('database.default');
define('MYSQL_HOST', config("database.connections.{$db_environment}.host"));
define('MYSQL_DB', config("database.connections.{$db_environment}.database"));
define('MYSQL_USER', config("database.connections.{$db_environment}.username"));
define('MYSQL_PASS', config("database.connections.{$db_environment}.password"));

/**
 * Site URL
 * Automatically set if you are working on a fork
 * @const SITE_URL
 */
define('SITE_URL', config('app.url'));
define('HTTPS_SITE_URL', config('app.url'));

if (!defined('CP_STATS_DOMAIN')) {
    $cp_domain = str_replace(['http://', 'https://', 'www.'], '', SITE_URL);
    define('CP_STATS_DOMAIN', $cp_domain);
}
