// Load Vue Filters
require('./plugins/mtc_vue_filters');
import store from '../../resources/js/store';

// Initialize Vue environment
// We have custom delimiters in twig
const vueEnvironment = new Vue({
    delimiters: ['[%', '%]'],
    el: '#vueContainer',
    store
});

$(document).ready(function () {
    'use strict';

/*
 * Select box replacement
 */

    if ($('select').length) {
        $('select:not(.vueControlled)').chosen({
            disable_search_threshold: 8
        });
    }

/*
 * Responsive Tables
 */

    if ($('table').hasClass('responsive')) {
        mtcResponsiveTables({
            breakpoint: window.breakpoints.mobile
        });
    }

    /*
     * Back to top link animation
     */

    $('a[href="#top"]').on('click', function (e) {
        e.preventDefault();

        $('html, body').animate({
            scrollTop: 0
        }, 'slow');
    });

}); // document ready
