window.resizePatternBrowserSidebar = function () {
    'use strict';

    if ($('.patternSidebar').height() < $('.patternContent').height()) {
        $('.patternSidebar').height($('.patternContent').height());
    }
}

$(document).ready(function() {
    'use strict';

    if ($('.patternWrap').length) {

        $(window).on('scroll', function (event) {

            var sidebar = $(".patternSidebar"),
                pattern_menu_wrap = $('.patternMenuWrap'),
                sidebar_position = sidebar.offset().top,
                top_padding = 20,
                window_position = $(window).scrollTop(),
                scroll_calculation = (window_position - sidebar_position) + top_padding;

                if (scroll_calculation >= 0) {
                    pattern_menu_wrap.stop(true, true).animate({
                        marginTop: scroll_calculation
                    });
                } else {
                    pattern_menu_wrap.stop(true, true).animate({
                        marginTop: 0
                    });
                }

        });

        $('.patternContent section').each(function () {

            $(this).waypoint(function(direction) {
                $('.patternsSidebar ul li').removeClass('active');
                $('a[href=#' + this.element.id + ']').toggleClass('active', direction === 'down');
            });

        });

        resizePatternBrowserSidebar();

    }

}); // document ready

$(window).on('resize', debouncer(function (e) {
    'use strict';

    if ($('.patternWrap').length) {
        resizePatternBrowserSidebar();
    }

}));
