$(document).ready(function () {

    $.each($("[data-editable-pagedata-id]"), function(index, val) {

		var t = $(this);

		if ( $.isNumeric(t.attr("data-editable-pagedata-id")) ) {

			t.tinymce({
				inline: true,

				plugins: [
                    "advlist autolink lists link image charmap print preview anchor",
                    "searchreplace visualblocks code fullscreen",
                    "insertdatetime media table contextmenu paste moxiemanager"
                ],

				menubar : false,
				
				statusbar : true,
				relative_urls : false,
				remove_script_host : false,
				convert_urls : true,
				/*
				convert_fonts_to_spans : true,
				paste_as_text: true,
				body_class: "wysiwigContent",
				*/

				toolbar: "image undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link insertfile",
				contextmenu: "link image inserttable | cell row column deletetable code"

				/*
				plugins: [
					"advlist autolink lists link image charmap print preview anchor",
					"searchreplace visualblocks code fullscreen",
					"insertdatetime media table contextmenu paste"
				],
				toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image"*/
			});

			t.blur(function(){

				var data = {
					id: t.attr("data-editable-pagedata-id"),
					value: t.html()
				};

				$.ajax({
					url: '/admin/ajax/content_manager/save-list-item-data-value.php',
					type: 'POST',
					dataType: 'html',
					data: data,
				})
				.done(function() {
					console.log("saved");
				})
				.fail(function() {
					console.log("error");
				});

			});

		}

    });

});