# fordnox/php-queue-manager bridge for core

## Installation
```
composer require mtcmedia/queue
```

## Usage

### Create a Message (job) class
This is completely your custom code except that it's extending Message class.
```php
<?php

namespace Mtc\Modules\Sessions\Classes;

use Queue\Message;

class PinEmail extends Message
{
    public $session;

    public $recipients;

    /**
     * PinEmail constructor.
     * @param $session
     * @param $recipients
     */
    public function __construct(Session $session, array $recipients)
    {
        $this->session = $session;
        $this->recipients = $recipients;
    }

    public function execute()
    {
        var_dump($this->recipients);
        dd('Handling pin email');
    }
}

```

### add message to queue
```php
use MtcMedia\Queue\Queue;
Queue::add(new PinEmail($session, $recipients));
```

### Work the queue
```php
$cron = new MtcCron();

if ($cron->start()) {
    \MtcMedia\Queue\Queue::work();
    
    $cron->stop();
}
```
