Queue library using database as backend and Eloquent for DB interaction.

# Installation

```
composer require mtcmedia/queue
```

# Usage

## Creating jobs

First, create a job class and implement the Queueable interface. The below example also serializes an Eloquent model 
into id and then 

```php
<?php

use MtcMedia\Queue\Queueable;

class PinEmail implements  \Serializable, Queueable
{
    public $session;

    public $recipients;

    /**
     * PinEmail constructor.
     * @param $session
     * @param $recipients
     */
    public function __construct(Session $session, array $recipients)
    {
        $this->session = $session;
        $this->recipients = $recipients;
    }

    // Queueable interface implementation

    public function execute()
    {
        // do the job here, this method is executed when processing (working) the queue
    }

    /**
     * Returns string representation of the object
     * @return string
     */
    public function getName()
    {
        return 'pin email';
    }

    // \Serializable interface implementation

    public function serialize()
    {
        return serialize([
            'session_id' => $this->session->id,
            'recipients' => $this->recipients,
        ]);
    }

    public function unserialize($serialized)
    {
        $data = unserialize($serialized);

        $this->session = Session::findOrFail($data['session_id']);
        $this->recipients = $data['recipients'];
    }
}

```

## Add a job to default queue
```php
<?php

use MtcMedia\Queue\QueueManager;

$manager = new QueueManager();
$manager->add(new PinEmail($session, []));
```

## Work the default queue
```php
<?php

$queue = $manager->getQueue();
// work default number of jobs (120)
$queue->work();
// work 1 job 
$queue->work(1);
```
