<?php

namespace Mtc\Realex\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Realex\Providers\RealexServiceProvider;

/**
 * Class InstallRealex
 *
 * @package Mtc\Realex
 */
class InstallRealex extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'install:realex';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Install Realex Payment Gateway assets';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        $this->info('Installing Realex');

        $this->callSilent('vendor:publish', [
            '--provider' => RealexServiceProvider::class,
            '--tag' => 'assets',
        ]);

        $this->info('Realex installed successfully.');
    }
}
