# Recently Viewed 

This package creates a dynamic list for tracking "views" for "users".
This system is build to flexibly allow any User type object to track views 
for any type of model. This flexibility allows tracking elements of differnt types / categories.

# Installation

```bash
composer require mtcmedia/recently-viewed

php artisan migrate
```

# Usage

```php
use Mtc\RecentlyViewed\Facades\RecentlyViewed;

RecentlyViewed::track($viewer, $viewed_object, $category);

$items_viewed = RecentlyViewed::get($viewer, $category, $limit);
```

# Configuration 

`recently_viewed.php` config can be published and allows defining following values:

```php
return [
    // Max limit of entries to keep per each category
    'history_per_category' => 5, 
];
```

Config can be published with following command:

```bash

php artisan vendor:publish --provider=Mtc\\RecentlyViewed\\RecentlyViewedProvider
```