<?php

namespace Mtc\RecentlyViewed\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class RecentlyViewedModel extends Model
{
    protected $table = 'recently_viewed';

    protected $fillable = [
        'viewer_id',
        'viewer_type',
        'category',
        'viewed_id',
        'viewed_type',
    ];

    public function viewer(): MorphTo
    {
        return $this->morphTo('viewer');
    }

    public function viewed(): MorphTo
    {
        return $this->morphTo('viewed');
    }
}
